C...converts GES list-data output to LaTeX
C
C    This program is free software: you can redistribute it and/or modify
C    it under the terms of the GNU General Public License as published by
C    the Free Software Foundation version 3 of the License
C
C    This program is distributed in the hope that it will be useful,
C    but WITHOUT ANY WARRANTY; without even the implied warranty of
C    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C    GNU General Public License for more details.
C
C    You should have received a copy of the GNU General Public License
C    along with this program.  If not, see <http://www.gnu.org/licenses/>.
C
C    Contact through http://www.computational-thermodynamics.mpg.de
C
C remaining:
C \Box for Va ??
C Charges with ^ ??
C T-ranges for interaction parameters ignored
C
      character line*80,cline*160,sites(10)*8,dline*80,phname*24
      character ch2*2,infil*80,utfil*80
      character phlex*24,phser*24,phserlex*24,eln*2,ellex*2
      common/tdb2latex1/phlex,phser(3),phserlex(3),eln(3),ellex(3)
      common/tdb2latex2/lphlex,nel,nsl,lphser(3),lellex(3)
      dimension lsites(10)
      logical eoline
      data mmm/10/

      write(6,7)
 7    format(' This is a program reading a LIST-DATA output'/
     &     ' from Thermo-Calc and generating a LaTeX output'/
     &     ' for nice publishing.  Output will be generated on a'/
     &     ' file with same name as input but with extention tex.'/
     &     ' Please note:'/
     &     ' - Phase names will be taken from file phnames.lis'/
     &     ' - Temperature ranges for interaction parameters ignored'/
     &     ' - UPPER case for all constituents except elements'//
     &     ' Input file name:')
      read(5,2000)infil
      k=index(infil,'.')
      if(k.le.0) then
         k=index(infil,' ')
         infil(k:)='.dat'
      endif
      open(20,file=infil,access='sequential',status='old')
      utfil=infil(1:k)//'tex'
      open(11,file=utfil,access='sequential',status='unknown')
C
      write(11,10)
 10   format('\\documentclass[12pt]{article}'/
     &     '\\textwidth 150mm'/'\\textheight 220mm'/
     &     '\\oddsidemargin  5mm'/'\\evensidemargin  5mm'/
     &     '\\topmargin -20pt'/'\\usepackage{amssymb}'/
     &     '%\\usepackage[utopia]{mathdesign}'/
     &     '%\\pagestyle{empty}'/'\\begin{document}'/'\\vspace{5mm}')
      nline=0
      call debugs
C...skip until ELEMENT
 100  continue
      read(20,2000)line
      nline=nline+1
      ipos=1
      if(eoline(line,ipos)) goto 100
      if(line(2:9).ne.'ELEMENT ') goto 100
C...skip element -1 and 0 (/- and VA)
 200  continue
      read(20,2000)line
      nline=nline+1
      ipos=1
      if(eoline(line,ipos)) stop 'error reading element data'
      if(line(ipos:ipos).eq.'0') goto 210
      read(20,2000)line
      nline=nline+1
C...decode elements
 210  continue
      nel=0
      lowcase=ichar('a')-ichar('A')
 220  continue
      read(20,2000)line
      nline=nline+1
      ipos=1
      if(eoline(line,ipos)) goto 290
      nel=nel+1
      if(nel.gt.3) stop 'max 3 elements'
      eln(nel)=line(5:6)
      phser(nel)=line(10:34)
      ellex(nel)=eln(nel)
      if(eln(nel)(2:2).ne.' ') then
         ellex(nel)(2:2)=char(ichar(eln(nel)(2:2))+lowcase)
         lellex(nel)=2
      else
         lellex(nel)=1
      endif
      call phnamestex(phser(nel),phserlex(nel),lphser(nel))
c      phserlex(nel)=phser(nel)
c      lphser(nel)=index(phser(nel),' ')-1
c 230  k=index(phserlex(nel),'_')
c      if(k.gt.0) then
c         phserlex(nel)(k:k)='-'
c         goto 230
c      endif
      goto 220
C...output system
 290  continue
      if(nel.eq.2) write(11,291)ellex(1)(1:lellex(1)),
     &     ellex(2)(1:lellex(2))
      if(nel.eq.3) write(11,292)ellex(1)(1:lellex(1)),
     &     ellex(2)(1:lellex(2)),ellex(3)(1:lellex(3))
 291  format('\\begin{center}'/'{\\Large \\bf System ',A,'--',A,'}'/
     &     '\\end{center}')
 292  format('\\begin{center}'/'{\\Large \\bf System ',A,'--',A,
     &     '--',a,'}'/'\\end{center}')
c      if(mmm.gt.0) write(6,291)ellex(1),ellex(2)
C...skip until SPECIES
 300  continue
      read(20,2000)line
      nline=nline+1
      ipos=1
      if(eoline(line,ipos)) goto 300
      if(line(2:9).ne.'SPECIES ') goto 300
C...skip all species
 310  continue
      read(20,2000)line
      nline=nline+1
      ipos=1
      if(eoline(line,ipos)) goto 400
      goto 310
C...next non-blank line is a phase name
 400  continue
      read(20,2000)line
      nline=nline+1
      ipos=1
C...extract phase name
 410  if(eoline(line,ipos)) goto 400
      phname=line(2:26)
      call phnamestex(phname,phlex,lphlex)
c      call phnameok(phname,phlex,lphlex)
      nsl=1
C...skip lines until SUBLATTICES (may not be present ...)
 420  read(20,2000)line
      nline=nline+1
      ipos=1
      if(line(5:17).eq.'SUBLATTICES, ') then
         cline=line(25:)
      elseif(line(5:18).eq.'CONSTITUENTS: ') then
         goto 435
      else
         goto 420
      endif
C...extract sublattice ratios
      nl=0
      last=1
 424  k=index(cline,':')
      if(k.gt.0) then
         nl=nl+1
         sites(nl)=cline(last:k-1)
         lsites(nl)=k-last
         last=k+3
         cline(k:k)=' '
         goto 424
      endif
C...last sublattice has no final :
      k=index(cline(last:),' ')
      nl=nl+1
      if(nl.gt.1) then
         sites(nl)=cline(last:last+k)
         lsites(nl)=k-1
         nsl=nl
      endif
C...next lines are CONSTITUENT, and after next empty line comes parameters
 430  read(20,2000)line
      nline=nline+1
      ipos=1
      if(eoline(line,ipos)) stop 'missing constituent line'
 435  continue
      if(line(5:18).eq.'CONSTITUENTS: ') then
         cline='('//line(19:)
      else
         goto 430
      endif
C...extract constitution, no conversion of element names
 440  continue
      k=index(cline,' : ')
      if(k.gt.0) then
         cline(k:k+2)=')&('
         goto 440
      endif
C...maybe one more line
      read(20,2000)line
      nline=nline+1
      ipos=1
      if(.not.eoline(line,ipos)) then
         k=index(cline,' ')
         cline(k:)=line(ipos:)
      endif
C...convert to upper/lower case
      mpos=2
 450  continue
      ch2=cline(mpos:mpos+1)
      if(ch2(1:1).eq.' ') goto 455
      if(ch2(1:1).ge.'A' .and. ch2(1:1).le.'Z') then
         if(ch2(2:2).ge.'A' .and. ch2(2:2).le.'Z') then
            cline(mpos+1:mpos+1)=char(ichar(ch2(2:2))+lowcase)
            mpos=mpos+2
         elseif(ch2(2:2).eq.',') then
            mpos=mpos+2
         elseif(ch2(2:2).eq.')') then
            mpos=mpos+4
         elseif(ch2(2:2).eq.' ') then
            goto 455
         else
            mpos=mpos+1
         endif
      else
         mpos=mpos+1
      endif
      goto 450
 455  continue
C...add stoichiometry
      kd=1
      kc=1
      dline=' '
      nl=1
 460  continue
      k=index(cline,')&')
      if(k.gt.0) then
         dline(kd:)=cline(kc:k)//'$_{'//sites(nl)(1:lsites(nl))//'}$'
         kd=index(dline,' ')
         cline(k+1:k+1)='-'
         kc=k+2
         nl=nl+1
         goto 460
      endif
C...last or only sublattice
      if(nsl.eq.1) then
         dline=cline
         kd=index(dline,' ')
         dline(kd:kd)=')'
      else
         k=index(cline,' ')-1
         dline(kd:)=cline(kc:k)//')$_{'//sites(nl)(1:lsites(nl))//'}$'
         kd=index(dline,' ')-1
      endif
C...phase name and model
 500  continue
      write(11,501)phlex(1:lphlex),dline(1:kd)
      if(mmm.gt.0) write(6,501)phlex(1:lphlex),dline(1:kd)
 501  format('{\\large \\bf \\boldmath $\\rm ',a,'$} \\hspace{3mm}',a)
C...decode parameters for a phase
      read(20,2000)line
      nline=nline+1
      ipos=1
      call par2latex(line,ipos,modf,nline)
C...skip empty lines until next phase or 'SYMBOL'
 590  continue
      if(eoline(line,ipos)) then
         read(20,2000,end=800)line
         nline=nline+1
         ipos=1
         goto 590
      endif
      if(line(2:8).eq.'SYMBOL ') goto 600
      goto 410
C...decode all functions
 600  continue
      write(11,2000)'{\\large \\bf Functions}'
      modf=1
      read(20,2000)line
      nline=nline+1
      ipos=1
      iex=0
      call fun2latex(line,ipos,modf,nline,iex)
C...references??
C
 800  continue
      write(11,*)'\\end{document}'
      close(20)
      close(11)
      write(6,*)' read ',nline,' lines'
 2000 format(a)
      end

      subroutine fun2latex(str,kpos,modf,nline,iex)
C...converts a function to LaTeX, line contains first line on call
C     more lines may be read
C   2 RTLNP     20000000 +R*T*LN(1E-05*P)
C   3 GHSERCC   20000000 -17368.441+170.73*T-24.3*T*LN(T)-4.723E-04*T**2
C     +2562600*T**(-1)-2.643E+08*T**(-2)+1.2E+10*T**(-3)
C   4 GPCLIQ    20000000 +YCLIQ*EXP(ZCLIQ)
C   5 GFELIQ    20000000 
C       298.15<T< 1811.00: +12040.17-6.55843*T-3.6751551E-21*T**7+GHSERFE
C      1811.00<T< 6000.00: -10839.7+291.302*T-46*T*LN(T)
C
      character str*(*),ch1*1,ch2*1,chd*1,symb1*8,tline*100,line*80
      logical eoline
      data mmm/0/
      save mmm

      ldesc=0
      ileftp=0
      line=str
      tline=' '
      itpos=1
      ipos=kpos
      if(mmm.gt.0) write(6,2000)line(1:60)
      if(modf.eq.1) then
C...symbol list
         write(11,2000)'\\begin{description}      %% symbol list begin'
      else
C...a single parameter expression, can start with T limits
         tline='$'
         itpos=2
         idollar=1
         k=index(line(ipos:),'<')
         if(k.gt.0) goto 850
         goto 200
      endif
C
C...return here for each new function
 100  continue
      symb1=line(6:13)
      tline='\\item '//symb1//' = $'
      itpos=19
      ipos=24
      idollar=1
      last=0
C value of last determine what has happend already
C 0 beginning of function
C 1 next must be legal part of number or terminating number
C 2 next must be number or symbol
C...reurn here for each new term
 200  continue
      if(eoline(line,ipos)) goto 800
      ipos=ipos-1
      ndig=0
 210  continue
      ipos=ipos+1
      if(ipos.gt.len(line)) goto 800
      ch1=line(ipos:ipos)
      if(mmm.gt.0) write(6,211)ipos,ch1
 211  format('f2t 210: ',i5,' "',a1,'"')
      if(ch1.eq.' ') then
C...normally there are no spaces except trailing spaces
         if(eoline(line,ipos)) goto 800
         ipos=ipos-1
         goto 210
      endif
      if(ch1.ge.'0' .and. ch1.le.'9') then
         tline(itpos:itpos)=ch1
         itpos=itpos+1
         last=2
         ndig=ndig+1
         chd=ch1
      elseif(ch1.eq.'+' .or. ch1.eq.'-') then
         tline(itpos+1:itpos+1)=ch1
         itpos=itpos+2
         last=1
         if(itpos.gt.40) then
            write(11,2000)tline(1:itpos)
            if(mmm.gt.0) write(6,2000)tline(1:itpos)
            tline=' '
            itpos=1
         endif
         ndig=0
      elseif(ch1.eq.'.') then
         tline(itpos:itpos)=ch1
         itpos=itpos+1
         last=2
      elseif(ch1.eq.')') then
         tline(itpos:itpos)=ch1
         itpos=itpos+1
         last=1
         ileftp=ileftp-1
         ndig=0
      elseif(ch1.eq.'*') then
C...multiplication or exponentiation
         if(line(ipos:ipos+1).eq.'**') then
            tline(itpos:)='^{'
            itpos=itpos+2
            ipos=ipos+2
            ch1=line(ipos:ipos)
            if(ch1.eq.'(') ipos=ipos+1
            ch1=line(ipos:ipos)
            if(ch1.eq.'-') then
               tline(itpos:)='-'
               itpos=itpos+1
               ipos=ipos+1
            endif
 300        continue
            ch1=line(ipos:ipos)
            if(ch1.ge.'0' .and. ch1.le.'9') then
               tline(itpos:)=ch1
               itpos=itpos+1
               ipos=ipos+1
               goto 300
            endif
            if(ch1.eq.')') then
               tline(itpos:)='}\\ '
               itpos=itpos+3
c               ipos=ipos+1
            elseif(ch1.eq.'*') then
               tline(itpos:)='}~'
               itpos=itpos+2
               ipos=ipos-1
            else
               tline(itpos:)='}\\ '
               itpos=itpos+3
               ipos=ipos-1
            endif
         else
            if(ndig.eq.1 .and. chd.eq.'1') then
C...if just 1* make it void
               itpos=itpos-1
               ndig=0
            else
C...a multiplication sign is transformed into a connecting space
               tline(itpos:)='\\,'
               itpos=itpos+2
            endif
         endif
      elseif(ch1.ge.'A' .and. ch1.le.'Z') then
C...handle LN and EXP directly
         ndig=0
         if(line(ipos:ipos+2).eq.'LN(') then
            if(last.gt.1) then
               tline(itpos:)='~\\ln('
               itpos=itpos+5
            else
               tline(itpos:)='\\ln('
               itpos=itpos+4
            endif
            ipos=ipos+2
            ileftp=ileftp+1
            goto 210
         elseif(line(ipos:ipos+3).eq.'EXP(') then
            if(last.gt.1) then
               tline(itpos:)='~\\exp('
               itpos=itpos+6
            else
               tline(itpos:)='\\exp('
               itpos=itpos+5
            endif
            ipos=ipos+3
            ileftp=ileftp+1
            goto 210
         endif
         issymb=0
         jpos=ipos
 310     jpos=jpos+1
         ch2=line(jpos:jpos)
         if((ch2.ge.'A' .and. ch2.le.'Z') .or. ch2.eq.'_' .or.
     &        (ch2.ge.'0' .and. ch2.le.'9')) then
C...must be a symbol, starts with letter, number and _ allowed later
            issymb=issymb+1
            goto 310
         elseif(issymb.gt.1) then
            symb1=line(ipos:jpos-1)
            tline(itpos:)='{\\rm '//line(ipos:jpos-1)//'}'
            itpos=itpos+6+jpos-ipos
            last=1
            ipos=jpos-1
         elseif((ch1.eq.'E' .or. ch1.eq.'e') .and.
     &          (ch2.eq.'+' .or. ch2.eq.'-')) then
C...only one letter, if E followed by sign it must be an exponent
            jtpos=itpos
            tline(itpos:)='\\cdot~10^{-'
            itpos=itpos+11
            if(ch2.eq.'+') itpos=itpos-1
            ipos=jpos+1
            jpos=itpos
            ch1=line(ipos:ipos)
            if(ch1.ge.'1' .and. ch1.le.'9') then
C...ignore first number if zero
               tline(itpos:itpos)=ch1
               itpos=itpos+1
            endif
            ipos=ipos+1
            ch2=line(ipos:ipos)
            if(ch2.ge.'1' .and. ch2.le.'9') then
               tline(itpos:itpos)=ch2
               itpos=itpos+1
            elseif(ch2.ge.'0' .and. ch1.ne.'0') then
C...if second number 0 ignore only if first was also 0
               tline(itpos:itpos)=ch2
               itpos=itpos+1
            endif
C            ipos=ipos+1
            if(itpos.eq.jpos) then
C...  one can have exponents E+00, erase them
               itpos=jtpos
            else
               tline(itpos:)='}'
               itpos=itpos+1
            endif
         elseif((ch1.eq.'T' .or. ch1.eq.'P') .and.
     &          (ch2.eq.'+' .or. ch2.eq.'-' .or. 
     &           ch2.eq.'*' .or. ch2.eq.' ' .or. ch2.eq.')')) then
C23456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789
C...single letter symbol equal to T and P with possible power
            tline(itpos:)='\\,'//ch1
            itpos=itpos+3
C            ipos=jpos-1
C         elseif(?????
         else
C...accept it is a single letter symbol, it can be R
            symb1=line(ipos:jpos-1)
            tline(itpos:)='{\\rm '//line(ipos:jpos-1)//'}'
            itpos=itpos+6+jpos-ipos
            last=1
         endif
C      elseif(ch1.eq.'????') then
      else
         write(6,*)'Unrecognized character: ',ch1
         stop 'never here'
      endif
      goto 210
C
C...read new line but first write the present
 800  continue
      if(tline(itpos-1:itpos-1).ne.'$') then
         tline(itpos:)='$'
         itpos=itpos+1
      else
         itpos=itpos-2
      endif
      idollar=0
      if(itpos.gt.0) then
         write(11,2000)tline(1:itpos)
         if(mmm.gt.0) write(6,2000)tline(1:itpos)
      endif
      tline=' '
      itpos=1
      read(20,2000)line
      nline=nline+1
      if(mmm.gt.0) write(6,2000)line(1:72)
      ipos=1
      if(eoline(line,ipos)) then
         if(iex.eq.1) write(11,2000)'\\\\'
         goto 880
      endif
      if(ipos.le.4) then
C...new function
         if(ldesc.ne.0) then
            write(11,2000)'\\end{description}         %% T-range end'
            ldesc=0
         endif
         goto 100
      elseif(modf.ne.1) then
C...a semicolon on the line indicates a new parameter
         if(index(line,';').gt.0) then
            if(iex.eq.1) write(11,2000)'\\\\'
            goto 880
         endif
      endif
C...handle T limits here, note they can appear on the parameter line
C     which has : characters
 850  continue
      leq=index(line,'<')
      if(leq.gt.0) then
         lcol=index(line(ipos:),':')+ipos-1
C...ignore T-ranges when iex=1
         if(iex.eq.1) then
            ipos=lcol+1
            goto 200
         endif
         if(ldesc.eq.0) then
            write(11,2000)'\\begin{description}        %% T-range begin'
            ldesc=1
         endif
         if(modf.eq.1) then
C...modf=1 for the function list
            iopos=6
         else
            iopos=ipos
         endif
         tline='\\item $'//line(iopos:leq-1)//' \\leq \\ '
     &        //line(leq+1:lcol)//'$'
C         itpos=14+leq-iopos+lcol-leq-1+1
         itpos=17+lcol-iopos
         write(11,2000)tline(1:itpos)
         if(mmm.gt.0) write(6,*)tline(1:itpos)
         tline='$'
         itpos=2
         ipos=lcol+1
      else
         if(idollar.eq.0) then
            tline='$'
            itpos=2
            idollar=1
         endif
         ipos=6
      endif
      goto 200
 880  continue
      if(ldesc.eq.1) then
         write(11,2000)'\\end{description}         %% T-range end'
      endif
      if(modf.eq.1) then
         write(11,2000)'\\end{description}      %% symbols list end'
      endif
 900  kpos=ipos
      str=line
      return
C formats
 2000 format(a)
      end

      logical function eoline(line,ipos)
      character line*(*)
      if(ipos.le.0) ipos=1
 10   if(ipos.gt.len(line)) goto 200
      if(line(ipos:ipos).eq.' ') then
         ipos=ipos+1
         goto 10
      endif
      eoline=.false.
      goto 900
 200  eoline=.true.
 900  return
      end

      subroutine par2latex(str,kpos,modf,nline)
C...converts a parameter name to LaTeX, line contains first line on call
C     more lines may be read
c      G(HCP_A3,FE:C;0)-0.5 H298(GRAPHITE,C;0)-H298(BCC_A2,FE;0) = +52905
c           -11.9075*T+GFEFCC+.5*GHSERCC+GPCFCC
c      G(HCP_A3,NI:C;0)-0.5 H298(GRAPHITE,C;0)-H298(FCC_A1,NI;0) = +34796
c           +2.665*T+GHSERNI+.5*GHSERCC
c      BMAGN(HCP_A3,NI:C;0) = .52
c      G(HCP_A3,FE:VA;0)-H298(BCC_A2,FE;0) = 
c             298.15<T< 1811.00: -3705.78+12.591*T-1.15*T*LN(T)+6.4E-04*T**2
c           +GHSERFE+GPFEHCP
c            1811.00<T< 6000.00: -3957.199+5.24951*T+4.9251E+30*T**(-9)
c           +GHSERFE+GPFEHCP
c      G(HCP_A3,NI:VA;0)-H298(FCC_A1,NI;0) = 
c             298.15<T< 3000.00: +1046+1.255*T+GHSERNI
c      TC(HCP_A3,NI:VA;0) = 633
c      BMAGN(HCP_A3,NI:VA;0) = .52
c      L(HCP_A3,FE,NI:C;0) = +49074-7.32*T
C
      character str*(*),ch1*1,ch2*1,chd*1,pid*8,tline*100,line*80
      character tdbpid(20)*8,phasename*24,texpid(20)*12,pidt*12,dline*80
      character constit*24,cht*1,deg*1,refid*4,reffas*24,refel*2
      character phlex*24,phser*24,phserlex*24,eln*2,ellex*2
      common/tdb2latex1/phlex,phser(3),phserlex(3),eln(3),ellex(3)
      common/tdb2latex2/lphlex,nel,nsl,lphser(3),lellex(3)
      logical eoline,nofakt,faktor
C...parameter symbol names that can be generated, note L for excess
      data tdbpid( 1)/'G       '/,tdbpid( 2)/'TC      '/
      data tdbpid( 3)/'BMAGN   '/,tdbpid( 4)/'THETA   '/
      data tdbpid( 5)/'V0      '/,tdbpid( 6)/'VA      '/
      data tdbpid( 7)/'VC      '/,tdbpid( 8)/'VK      '/
      data tdbpid( 9)/'ED      '/,tdbpid(10)/'        '/
      data tdbpid(11)/'TE      '/,tdbpid(12)/'GAMTE   '/
      data tdbpid(13)/'Q       '/,tdbpid(14)/'A2      '/
      data tdbpid(15)/'GAMA2   '/,tdbpid(16)/'        '/
      data tdbpid(17)/'        '/,tdbpid(18)/'        '/
      data tdbpid(19)/'        '/,tdbpid(20)/'        '/

      data texpid( 1)/'G           '/, texpid( 2)/'{T_{\\!C}}   '/
      data texpid( 3)/'\\beta       '/,texpid( 4)/'\\theta      '/
      data texpid( 5)/'{V_0}       '/, texpid( 6)/'{V_A}        '/
      data texpid( 7)/'{V_C}       '/, texpid( 8)/'{V_K}        '/
      data texpid( 9)/'ED          '/, texpid(10)/'            '/
      data texpid(11)/'{T_E}       '/, texpid(12)/'GAMTE       '/
      data texpid(13)/'Q           '/, texpid(14)/'{A_2}       '/
      data texpid(15)/'{\\gamma_2}  '/, texpid(16)/'            '/
      data texpid(17)/'            '/, texpid(18)/'            '/
      data texpid(19)/'            '/, texpid(20)/'            '/

      data mmm/0/
      save mmm

      line=str
      ipos=kpos
      idollar=0
      iex=0
      write(11,2000)'\\begin{description}       %% endmember begin'
      
C...start reading the line, if empty exit
 100  continue
      if(eoline(line,ipos)) goto 900
      if(mmm.gt.0) write(6,*)' p2l 100: ',line(1:60)

C...extract parameter identifier
 200  jpos=index(line(ipos:),'(')
      if(ipos.le.0) goto 910
      pid=line(ipos:ipos+jpos-2)
      ipos=ipos+jpos
      lpid=jpos-1
      if(pid(1:2).eq.'L ') then
         pidt='L'
         ipid=0
         lpid=1
         goto 220
      endif
      do 210 ipid=1,20
         if(pid.eq.tdbpid(ipid)) goto 215
 210  continue
      goto 920
 215  pidt=texpid(ipid)
      lpid=index(pidt,' ')-1
C...phase name, can be ignored, use COMMON phlex
 220  jpos=index(line(ipos:),',')
      if(jpos.le.0) goto 920
      phasename=line(ipos:ipos+jpos-2)
      kkk=index(line,';')+1
      if(kkk.gt.0) then
         deg=line(kkk:kkk)
      else
         deg='0'
      endif
      if(iex.eq.0) then
         tline='\\item $~^{\\circ}'//pidt(1:lpid)//'^{\\rm '//
     &        phlex(1:lphlex)//'}_{\\rm '
         itpos=30+lpid+lphlex
         itcar=itpos
      else
            tline='$^'//deg//pidt(1:lpid)//'^{\\rm '//
     &           phlex(1:lphlex)//'}_{\\rm '
            itpos=17+lpid+lphlex
c         endif
      endif
      ipos=ipos+jpos
C...constituent array, note reading of new lines may be needed
 240  continue
      cht='}'
      l1pos=index(line(ipos:),':')
      l2pos=index(line(ipos:),',')
      l3pos=index(line(ipos:),';')
      llpos=1000
      if(l1pos.gt.0) llpos=l1pos
      if(l2pos.gt.0 .and. l2pos.lt.llpos) llpos=l2pos
      if(l3pos.gt.0 .and. l3pos.lt.llpos) llpos=l3pos
      if(llpos.eq.1000) goto 800
      if(llpos.eq.l2pos) then
C...excess parameter.  , before : or ;
         if(iex.eq.0) then
            write(11,*)'\\end{description}            %% endmembers end'
            write(11,*)'\\begin{tabular}{lcl}  %% excess parameters end'
C...the beginning of tline must be changed also
c            tline='$'//pidt(1:lpid)//'^{\\rm '//
            dline=tline(itcar:)
            kk=index(dline,' ')-1
            tline='$^'//deg//pidt(1:lpid)//'^{\\rm '//
     &           phlex(1:lphlex)//'}_{\\rm '
            itpos=17+lpid+lphlex
            if(kk.gt.0) then
C...if necessary add constituents in earlier sublatices
               tline(itpos:)=dline
               itpos=itpos+kk
            endif
            iex=1
         endif
         cht=','
      elseif(llpos.eq.l1pos) then
C...final or only constituent in sublattice
         cht=':'
      endif
C...the constituent is between ipos and jpos
      constit=line(ipos:ipos+llpos-2)
      lconstit=llpos-1
      if(constit(3:3).eq.' ') then
         do 250 iee=1,nel
            if(constit(1:2).eq.eln(iee)) goto 260
 250     continue
      endif
C...one can have other constituents than the elements
      tline(itpos:)=constit(1:lconstit)//cht
      itpos=itpos+lconstit+1
      goto 270
 260  tline(itpos:)=ellex(iee)(1:lellex(iee))//cht
      itpos=itpos+lellex(iee)+1
 270  continue
      ipos=ipos+llpos
      if(llpos.ne.l3pos) goto 240
C end of constituent array
 300  continue
      if(iex.eq.0) then
         if(ipid.ne.1) then
            tline(itpos:)='$ = \\hspace{3mm}'
            itpos=itpos+15
         else
C...here decode the -H298 terms for the elements
c      G(HCP_A3,NI:VA;0)-H298(FCC_A1,NI;0) = 
c             298.15<T< 3000.00: +1046+1.255*T+GHSERNI
c      TC(HCP_A3,NI:VA;0) = 633
c     presently just add
c            goto 380
c...bypass 0)
            ipos=ipos+2
            l4pos=1000
 320        missing=1
 330        continue
            if(eoline(line,ipos)) then
               read(20,2000,end=900)line
               nline=nline+1
               ipos=1
               goto 330
            endif
c            if(missing.eq.1 .and. l4pos.eq.0 .and. 
c     &           line(ipos:ipos+1).eq.'0)') then
            if(line(ipos:ipos+2).eq.'0) ' .or.
     &         line(ipos:ipos+2).eq.'0)=' .or.
     &         line(ipos:ipos+2).eq.'0)-') then
C...this can happen when a constituent array has newline after ;
               ipos=ipos+2
               goto 330
            endif
            ch1=line(ipos:ipos)
            if(line(ipos:ipos).eq.'=' .or.
     &         line(ipos:ipos+1).eq.' =') goto 385
C...rarely
            if(line(ipos:ipos+2).eq.'***') goto 385
            if(line(ipos:ipos).ne.'-') then
c               if(.not.nofakt .or. missing.gt.1) then
               if(faktor .or. missing.gt.1) then
C...when a line break after a factor this can happen
                  ipos=ipos-1
                  goto 340
               endif
               write(6,*)'Error in G parameter on line ',nline
               stop
            endif
            ch1=line(ipos+1:ipos+1)
            if(ch1.ne.' ' .and. (ch1.lt.'0' .or. ch1.gt.'9')) then
               tline(itpos:itpos)='-'
               itpos=itpos+1
c               nofakt=.true.
               faktor=.false.
            else
C...take care of any numeric factor, like in
C   G(BCC_A2,CR:C;0)- 3 H298(GRAPHITE,C;0)-H298(BCC_A2,CR;0) = +GHSERCR
               faktor=.true.
c               nofakt=.false.
c               if(ch1.ne.' ') then
c                  tline(itpos:itpos)='X'
c                  itpos=itpos+1
c               endif
               ipos=ipos+1
               tline(itpos:itpos)='-'
               itpos=itpos+1
 333           continue
               tline(itpos:itpos)=ch1
               itpos=itpos+1
               ipos=ipos+1
               ch1=line(ipos:ipos)
               if(ch1.ne.' ') goto 333
            endif
 340        continue
C...the reference may be on two lines ...
            goto (341,342,343),missing
 341        l1pos=index(line(ipos:),'(')
 342        l2pos=index(line(ipos:),',')
 343        l3pos=index(line(ipos:),';')
c            l4pos=index(line(ipos:),')')
C...note ... there can be ) in the phase name ...
            l4pos=l3pos+2
            if(l3pos.eq.0) l4pos=0
            if(l1pos.eq.0) goto 330
            if(missing.eq.1) refid=line(ipos+1:ipos+l1pos-2)
            if(l2pos.eq.0) then
               l1pos=-1
               missing=2
C...force reading new line for missing information
               ipos=len(line)
               goto 330
            elseif(l3pos.eq.0) then
               reffas=line(ipos+l1pos:ipos+l2pos-2)
               l2pos=1
               missing=3
               ipos=len(line)
               goto 330
            elseif(missing.le.2) then
               reffas=line(ipos+l1pos:ipos+l2pos-2)
            endif
            refel=line(ipos+l2pos:ipos+l3pos-2)
            if(itpos.gt.50) then
               write(11,2000)tline(1:itpos)
               tline=' '
               itpos=1
            endif
            tline(itpos:)='~^{\\circ}'//refid(1:1)//'^{\\rm '
            itpos=itpos+16
            do 350 nee=1,nel
               if(refel.eq.eln(nee)) goto 355
 350        continue
            stop 'unkown element'
 355        continue
            tline(itpos:)=phserlex(nee)(1:lphser(nee))//'}_{\\rm '
            itpos=itpos+lphser(nee)+7
            tline(itpos:)=ellex(nee)(1:lellex(nee))//'} '
            itpos=itpos+lellex(nee)+2
            if(l4pos.gt.0) then
               ipos=ipos+l4pos
            else
               kk=index(line(ipos+1:),' ')
               ipos=ipos+kk
            endif
            goto 320
C...dummy code
 380        write(11,2000)tline(1:itpos)
            tline=' - \\ldots ~^{\\circ}H^{\\rm SER}_{\\rm X}'
            itpos=38
 385        write(11,2000)tline(1:itpos)
            write(11,2000)'$ = \\hspace{3mm}'
            tline=' '
            itpos=1
         endif
      else
         tline(itpos:)='$ & = & '
         itpos=itpos+8
      endif
 390  continue
      if(ipid.ne.1) then
         if(mmm.gt.0) write(6,*)tline(1:itpos)
         write(11,2000)tline(1:itpos)
         tline=' '
         itpos=1
         modf=2
C...  ipos should inidcate position of ; increment past = sign
         ipos=ipos+5
         call fun2latex(line,ipos,modf,nline,iex)
C...line with next parameter already read by fun2latex
         goto 500
      endif
 400  continue
      ipos=index(line,' ***')
      if(ipos.gt.0) then
         tline(itpos:)=' UNASSESSED'
         itpos=itpos+11
         write(11,2000)tline(1:itpos)
         if(mmm.gt.0) write(6,*)tline(1:itpos)
         tline=' '
         itpos=1
         read(20,2000)line
         nline=nline+1
         ipos=1
         goto 500
      endif
      ipos=index(line,'=')
      if(ipos.le.0) then
         read(20,2000)line
         nline=nline+1
         goto 400
      endif
      ipos=ipos+1
      if(itpos.gt.1) then
         write(11,2000)tline(1:itpos)
         if(mmm.gt.0) write(6,*)tline(1:itpos)
      endif
      tline=' '
      itpos=1
      modf=2
      call fun2latex(line,ipos,modf,nline,iex)
      goto 500
C...if line empty there are no more parameters
 500  if(eoline(line,ipos)) goto 900
      goto 200
C...read new line
 800  continue
      if(itpos.eq.idollar) then
         itpos=itpos-1
      else
         tline(itpos:itpos)='$'
      endif
      idollar=0
      if(itpos.gt.1) then
         tline(itpos:itpos)='$'
         write(11,2000)tline(1:itpos)
         if(mmm.gt.0) write(6,2000)tline(1:itpos)
      endif
      tline=' '
      itpos=1
      read(20,2000)line
      nline=nline+1
      ipos=1
      goto 100
C
 900  continue
      if(iex.eq.0) then
         write(11,2000)'\\end{description}             %% endmember end'
      elseif(iex.eq.1) then
         write(11,2000)'\\end{tabular}         %% excess parameters end'
      endif
      write(11,2000)'%%%%%%%%%%% end of phase %%%%%%%%%%'
      write(11,2000)'\\vspace{3mm}'
      write(11,2000)' '
      write(11,2000)'\\noindent'
      str=line
      kpos=ipos
      return
C errors
 910  continue
 920  continue
C format
 2000 format(a)
      end

      subroutine phnameok(phname,phlex,nl)
C...checks phase name agains file and returns latex type name
C     now dummy
      character phname*(*),phlex*(*)
      phlex=phname
 100  k=index(phlex,'_')
      if(k.gt.0) then
         phlex(k:k)='-'
         goto 100
      endif
      nl=index(phlex,' ')-1
 900  return
      end

      subroutine debugs
 900  return
      end


       subroutine phnamestex(chtdb,chlatex,lennam)
C...check phase names and return LaTeX form
       character*(*) chlatex,chtdb
       character ch24*24,chformt*24
 9020  format(a24,a24)
       open(unit=3,file='phnames.lis')
       cph=cht

 100   read(3,9020,end=8000) ch24,chformt

       if (ch24 .ne. chtdb ) go to 100
       chlatex=chformt
       go to 8100
      
 8000  continue
       write (6,8010)chtdb
 8010  format(' Phase ',A,' unknown'/
     &          ' Please add in file "phnames.lis"')
       chlatex=chtdb
 8020  continue
       k=index(chlatex,'_')
       if(k.gt.0) then
          chlatex(k:k)='-'
          goto 8020
       endif
      
 8100  continue
       lennam=index(chlatex,' ')-1
       close(unit=3) 
       return
       end

      integer function match2(str1,str2,ipos)
C...seaches for next occurance of str2 in str1 from ipos
      character str1*(*),str2*(*)
      ip=index(str1(ipos:),str2)
      if(ip.eq.0) then
         ipos=0
      else
         ipos=ipos+ip-1
      endif
 900  return
      end

